/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInfoBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;

public class DNSBean
extends PanelBean
implements SettingsConstants,
SettingsErrorIds {
    private boolean m_bDnsEnabled;
    private String m_sDnsServer;
    private String m_sDnsServers;
    private ValueDescriptor[] m_cdDnsServers;
    private String m_sDomainSuffix;
    private String m_sDomainSuffixes;
    private ValueDescriptor[] m_cdDomainSuffixes;
    private NetworkInfo _networkInfo;
    private String[] DNS_Entries;
    private String[] suffix_Entries;
    private static final String TRACE_MASKT = "XSETDNST";
    private static final String TRACE_MASKF = "XSETDNSF";
    private static final String TRACE_MASKD = "XSETDNSD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "DNSBean");
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);

    public boolean isDnsEnabled() {
        Trace.trace(TRACE_MASKT, "DNSBean: isDnsEnabled : " + this.m_bDnsEnabled);
        return this.m_bDnsEnabled;
    }

    public void setDnsEnabled(boolean b) throws IllegalUserDataException {
        this.m_bDnsEnabled = b;
        Trace.trace(TRACE_MASKT, "DNSBean: setDnsEnabled : " + this.m_bDnsEnabled);
        if (this.getMountPrefix() != null) {
            Trace.trace(TRACE_MASKT, "DNS value = " + b);
            if (b) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServer", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDNS", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServers", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDNS", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffix", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDomainSuffix", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffixes", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDomainSuffix", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DNSSEARCHLABEL", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DOMAINSUFFIXLABEL", true);
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServer", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDNS", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServers", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDNS", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffix", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDomainSuffix", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffixes", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDomainSuffix", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DNSSEARCHLABEL", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DOMAINSUFFIXLABEL", false);
            }
        }
    }

    public String getDnsServer() {
        return this.m_sDnsServer;
    }

    public void setDnsServer(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "DNSBean: setDnsServer run: " + s);
        if (!NetworkInfo.isValidIPAddr(s)) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDnsServer = s;
    }

    public String getDnsServers() {
        Trace.trace(TRACE_MASKT, "DNSBean: getDnsServers()");
        return this.m_sDnsServers;
    }

    public void setDnsServers(String s) throws IllegalUserDataException {
        this.m_sDnsServers = s;
        Trace.trace(TRACE_MASKT, "<> DNSBean.setDnsServers [" + s + "]");
    }

    public ValueDescriptor[] getDnsServersList() {
        if (this.m_cdDnsServers != null) {
            Trace.trace(TRACE_MASKT, "DNSBean: getDnsServersList(), m_cdDnsServers.length = " + this.m_cdDnsServers.length);
            for (int i = 0; i < this.m_cdDnsServers.length; ++i) {
                Trace.trace(TRACE_MASKT, "ValueDescriptor: getDnsServersList = [" + this.m_cdDnsServers[i].getName() + " , " + this.m_cdDnsServers[i].getTitle() + "]");
            }
        }
        return this.m_cdDnsServers;
    }

    public void setDnsServersList(ValueDescriptor[] items) {
        for (int i = 0; i < items.length; ++i) {
            Trace.trace(TRACE_MASKT, "ValueDescriptor: getDnsServersList = [" + items[i].getName() + " , " + items[i].getTitle() + "]");
        }
        this.m_cdDnsServers = items;
    }

    public String getDomainSuffix() {
        return this.m_sDomainSuffix;
    }

    public void setDomainSuffix(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "DNSBean: setDomainSuffix (w/'-' support2) run: " + s);
        if (!StringUtils.isValid(s, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-")) {
            Trace.trace(TRACE_MASKT, "invalidValueMsg.toString() " + this.invalidValueMsg.toString());
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDomainSuffix = s;
    }

    public String getDomainSuffixes() {
        return this.m_sDomainSuffixes;
    }

    public void setDomainSuffixes(String s) throws IllegalUserDataException {
        this.m_sDomainSuffixes = s;
        Trace.trace(TRACE_MASKT, "<> DNSBean.setDomainSuffixes [" + s + "]");
    }

    public ValueDescriptor[] getDomainSuffixesList() {
        if (this.m_cdDomainSuffixes != null) {
            for (int i = 0; i < this.m_cdDomainSuffixes.length; ++i) {
                Trace.trace(TRACE_MASKT, "ValueDescriptor: getDomainSuffixesList = [" + this.m_cdDomainSuffixes[i].getName() + " , " + this.m_cdDomainSuffixes[i].getTitle() + "]");
            }
        }
        return this.m_cdDomainSuffixes;
    }

    public void setDomainSuffixesList(ValueDescriptor[] items) {
        this.m_cdDomainSuffixes = items;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "<- DNSBean.panelAction()" + command);
        Object uiExc = null;
        try {
            ValueDescriptor[] vd;
            UserTaskManager utm = (UserTaskManager)event.getSource();
            DNSBean beans = this;
            Object[] allBeans = utm.getDataObjects();
            String myBeanName = this.getClass().getName();
            for (int i = 0; i < allBeans.length; ++i) {
                String beanName = allBeans[i].getClass().getName();
                if (!beanName.equals(myBeanName)) continue;
                beans = (DNSBean)utm.getDataObjects()[i];
            }
            beans.storeMyElements();
            if (command.endsWith("addDNS")) {
                Trace.trace(TRACE_MASKT, "ADD_DNS_BUTTON pressed!  getDnsServer() = " + this.getDnsServer());
                String newDnsServer = this.getDnsServer();
                vd = this.getDnsServersList();
                Trace.trace(TRACE_MASKT, "newDnsServer.length = " + newDnsServer.length());
                if (newDnsServer.length() != 0) {
                    beans.addToList(vd, newDnsServer, "DNS");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Add; ignore button press");
                }
                beans.setDnsServer("");
            } else if (command.endsWith("removeDNS")) {
                Trace.trace(TRACE_MASKT, "REMOVE_DNS_BUTTON pressed! getDnsServers() = " + this.getDnsServers());
                String newDnsServer = beans.getDnsServers();
                vd = this.getDnsServersList();
                if (vd.length != 0) {
                    beans.deleteRow(vd, newDnsServer, "DNS");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Remove; ignore button press");
                }
            } else if (command.endsWith("addDomainSuffix")) {
                Trace.trace(TRACE_MASKT, "ADD_DOMAINSUFFIX_BUTTON pressed! getDomainSuffix() = " + this.getDomainSuffix());
                String newDomainSuffix = this.getDomainSuffix();
                vd = this.getDomainSuffixesList();
                if (newDomainSuffix.length() != 0) {
                    this.addToList(vd, newDomainSuffix, "DomainSuffix");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Add; ignore button press");
                }
                this.setDomainSuffix("");
            } else if (command.endsWith("removeDomainSuffix")) {
                Trace.trace(TRACE_MASKT, "REMOVE_DOMAINSUFFIX_BUTTON pressed! getDomainSuffixes() = " + this.getDomainSuffixes());
                String newDomainSuffix = this.getDomainSuffixes();
                vd = this.getDomainSuffixesList();
                if (vd.length != 0) {
                    this.deleteRow(vd, newDomainSuffix, "DomainSuffix");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Remove; ignore button press");
                }
            }
            beans.refreshMyElements();
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 2393, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- DNSBean.panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> DNSBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("dnspanel");
        if (command.endsWith("okButton") || command.endsWith("applyButton")) {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (DNSBean) ");
            this._networkInfo.setDNSEnabled(this.isDnsEnabled());
            int num_DNS_Entries = this.m_cdDnsServers.length;
            this.DNS_Entries = new String[num_DNS_Entries];
            for (int i = 0; i < num_DNS_Entries; ++i) {
                this.DNS_Entries[i] = this.m_cdDnsServers[i].getTitle();
                Trace.trace(TRACE_MASKT, "DNS_Entries[i] = " + this.DNS_Entries[i]);
            }
            int num_Suffix_Entries = this.m_cdDomainSuffixes.length;
            this.suffix_Entries = new String[num_Suffix_Entries];
            for (int i = 0; i < num_Suffix_Entries; ++i) {
                this.suffix_Entries[i] = this.m_cdDomainSuffixes[i].getTitle();
                Trace.trace(TRACE_MASKT, "suffix_Entries[i] = " + this.suffix_Entries[i]);
            }
            this._networkInfo.setDNSServers(this.DNS_Entries);
            this._networkInfo.setDomainSuffixes(this.suffix_Entries);
            request.setData("panel", "dnspanel");
            request.setData("dataupdates", this._networkInfo);
            this.postTaskletRequest(request);
        } else if (command.endsWith("cancelButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (DNSBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            int num_DNS_Entries = this.m_cdDnsServers.length;
            int num_Suffix_Entries = this.m_cdDomainSuffixes.length;
            Trace.trace(TRACE_MASKT, "_networkInfo.isDNSEnabled() = " + this._networkInfo.isDNSEnabled() + "; m_bDnsEnabled = " + this.m_bDnsEnabled);
            Trace.trace(TRACE_MASKT, "_networkInfo.getDNSServers().length = " + this._networkInfo.getDNSServers().length + "; num_DNS_Entries = " + num_DNS_Entries);
            Trace.trace(TRACE_MASKT, "_networkInfo.getDomainSuffixes().length = " + this._networkInfo.getDomainSuffixes().length + "; num_Suffix_Entries = " + num_Suffix_Entries);
            if (this._networkInfo.isDNSEnabled() == this.m_bDnsEnabled && this._networkInfo.getDNSServers().length == num_DNS_Entries && this._networkInfo.getDomainSuffixes().length == num_Suffix_Entries) {
                int i;
                boolean foundDifferences = false;
                for (i = 0; i < num_DNS_Entries; ++i) {
                    if (this._networkInfo.getDNSServers()[i].equals(this.m_cdDnsServers[i].getTitle()) || foundDifferences) continue;
                    Trace.trace(TRACE_MASKT, "_networkInfo.getDNSServers()[i] = [" + this._networkInfo.getDNSServers()[i] + "]");
                    Trace.trace(TRACE_MASKT, "m_cdDnsServers[i].getTitle() = [" + this.m_cdDnsServers[i].getTitle() + "]");
                    foundDifferences = true;
                    ((NetworkInfoBean)parent).setDataChanged();
                    Trace.trace(TRACE_MASKT, "DNSBean believes data has changed");
                }
                for (i = 0; i < num_Suffix_Entries; ++i) {
                    if (this._networkInfo.getDomainSuffixes()[i].equals(this.m_cdDomainSuffixes[i].getTitle()) || foundDifferences) continue;
                    Trace.trace(TRACE_MASKT, "_networkInfo.getDomainSuffixes()[i] = " + this._networkInfo.getDomainSuffixes()[i]);
                    Trace.trace(TRACE_MASKT, "m_cdDomainSuffixes[i].getTitle() = " + this.m_cdDomainSuffixes[i].getTitle());
                    foundDifferences = true;
                    ((NetworkInfoBean)parent).setDataChanged();
                    Trace.trace(TRACE_MASKT, "DNSBean believes data has changed");
                }
            } else {
                ((NetworkInfoBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKT, "DNSBean believes data has changed");
            }
        }
        Trace.trace(TRACE_MASKT, "<- DNSBean.parentalAction()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.prepare()");
        this.setDnsEnabled(this.isDnsEnabled());
        int num_DNS_Entries = this.DNS_Entries.length;
        this.m_cdDnsServers = new ValueDescriptor[num_DNS_Entries];
        for (int i = 0; i < num_DNS_Entries; ++i) {
            this.m_cdDnsServers[i] = new ValueDescriptor(this.DNS_Entries[i], this.DNS_Entries[i]);
            Trace.trace(TRACE_MASKT, "VDescr prepare: i= [" + i + "];  DNS_Entries[" + i + "] = [" + this.DNS_Entries[i] + "]");
        }
        int num_Suffix_Entries = this.suffix_Entries.length;
        this.m_cdDomainSuffixes = new ValueDescriptor[num_Suffix_Entries];
        for (int i = 0; i < num_Suffix_Entries; ++i) {
            this.m_cdDomainSuffixes[i] = new ValueDescriptor(this.suffix_Entries[i], this.suffix_Entries[i]);
            Trace.trace(TRACE_MASKT, "VDescr prepare: i= [" + i + "];  suffix_Entries[i] = [" + this.suffix_Entries[i] + "]");
        }
        if (num_DNS_Entries > 0) {
            this.setDnsServers(this.DNS_Entries[0]);
        }
        if (num_Suffix_Entries > 0) {
            this.setDomainSuffixes(this.suffix_Entries[0]);
        }
        Trace.trace(TRACE_MASKT, "getDnsServers() = [" + this.getDnsServers() + "]");
        Trace.trace(TRACE_MASKT, "getDomainSuffixes() = [" + this.getDomainSuffixes() + "]");
        Trace.trace(TRACE_MASKT, "<- DNSBean.prepare()");
    }

    private void addToList(ValueDescriptor[] vdList, String newElement, String listType) {
        int i;
        int numRows = vdList.length;
        Trace.trace(TRACE_MASKT, "numRows = [" + numRows + "]");
        String[] entries = new String[numRows];
        for (i = 0; i < numRows; ++i) {
            entries[i] = vdList[i].getTitle();
        }
        vdList = new ValueDescriptor[numRows + 1];
        i = 0;
        for (i = 0; i < numRows; ++i) {
            vdList[i] = new ValueDescriptor(entries[i], entries[i]);
            Trace.trace(TRACE_MASKT, "New copy loop: i= [" + i + "];\t entries[i] = [" + entries[i] + "];  entries[i] = [" + entries[i] + "]");
        }
        Trace.trace(TRACE_MASKT, "Out of loop now; numRows = [" + numRows + "]");
        vdList[numRows] = new ValueDescriptor(newElement, newElement);
        if (listType.equals("DNS")) {
            Trace.trace(TRACE_MASKT, "DNS List");
            this.setDnsServersList(vdList);
            this.setDnsServers(newElement);
        } else {
            Trace.trace(TRACE_MASKT, "Domain Suffix List");
            this.setDomainSuffixesList(vdList);
            this.setDomainSuffixes(newElement);
        }
    }

    private void deleteRow(ValueDescriptor[] vdList, String listItem, String listType) {
        Trace.trace(TRACE_MASKT, "-> DNSBean.deleteRow, listItem = " + listItem + "; listType = " + listType);
        int numRows = vdList.length;
        Trace.trace(TRACE_MASKT, "number of rows = " + numRows);
        if (numRows < 1) {
            Trace.trace(TRACE_MASKT, "Bail out - the table is empty");
            return;
        }
        String[] entries = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            entries[i] = vdList[i].getTitle();
        }
        vdList = new ValueDescriptor[--numRows];
        int j = 0;
        int i = 0;
        while (j < numRows) {
            Trace.trace(TRACE_MASKT, "listItem = [" + listItem + "]; entries[i] = " + entries[i]);
            if (listItem.equals(entries[i])) {
                ++i;
            }
            vdList[j] = new ValueDescriptor(entries[i], entries[i]);
            Trace.trace(TRACE_MASKT, "numRows = [" + numRows + "]");
            Trace.trace(TRACE_MASKT, "New copy loop: i= [" + i + "];\t entries[i] = [" + entries[i] + "];  entries[j] = [" + entries[j] + "]\n");
            ++j;
            ++i;
        }
        int listboxLength = vdList.length;
        Trace.trace(TRACE_MASKT, "new vdList.length = " + vdList.length);
        if (listType.equals("DNS")) {
            Trace.trace(TRACE_MASKT, "DNS List");
            this.setDnsServersList(vdList);
            this.m_sDnsServers = listboxLength > 0 ? vdList[listboxLength - 1].getTitle() : "";
        } else {
            Trace.trace(TRACE_MASKT, "Domain Suffix List");
            this.setDomainSuffixesList(vdList);
            if (listboxLength > 0) {
                this.setDomainSuffixes(vdList[listboxLength - 1].getTitle());
            } else {
                this.setDomainSuffixes("");
            }
        }
        Trace.trace(TRACE_MASKT, "<- DNSBean.deleteRow()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DnsEnabled");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DnsServer");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DnsServers");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DomainSuffix");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DomainSuffixes");
        Trace.trace(TRACE_MASKT, "<- DNSBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DnsEnabled");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DnsServer");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DnsServers");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DomainSuffix");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DomainSuffixes");
        Trace.trace(TRACE_MASKT, "<- DNSBean.refreshMyElements()");
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        Trace.trace(TRACE_MASKT, "-> DNSBean.setNetworkInfo();  dnsEnabled = " + networkInfo.isDNSEnabled());
        this.setDnsEnabled(networkInfo.isDNSEnabled());
        this.setDnsServer("");
        this.DNS_Entries = networkInfo.getDNSServers();
        this.setDomainSuffix("");
        this.suffix_Entries = networkInfo.getDomainSuffixes();
        this._networkInfo = networkInfo;
        Trace.trace(TRACE_MASKT, "<- DNSBean.setNetworkInfo()");
    }
}

